<?php
session_start();
require 'db_connection.php';

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Varsayılan tarih aralığı
$start_date = $_GET['start_date'] ?? date('Y-m-01');
$end_date = $_GET['end_date'] ?? date('Y-m-d');

// Belirtilen tarih aralığındaki toplam ciro ve teklif sayısı
$sql_revenue = "SELECT SUM(qi.quantity * qi.unit_price) AS total_revenue, COUNT(DISTINCT q.id) AS total_quotes
                FROM quotes q
                JOIN quote_items qi ON q.id = qi.quote_id
                WHERE q.status = 'completed' AND q.created_at BETWEEN ? AND ?";
$stmt_revenue = $conn->prepare($sql_revenue);
$stmt_revenue->bind_param("ss", $start_date, $end_date);
$stmt_revenue->execute();
$report_data = $stmt_revenue->get_result()->fetch_assoc();
$stmt_revenue->close();

// Belirtilen tarih aralığındaki en çok satan ürünler
$sql_top_sellers = "SELECT p.name, SUM(qi.quantity) AS total_sold
                    FROM quote_items qi
                    JOIN products p ON qi.product_id = p.id
                    JOIN quotes q ON q.id = qi.quote_id
                    WHERE q.status = 'completed' AND q.created_at BETWEEN ? AND ?
                    GROUP BY p.id
                    ORDER BY total_sold DESC
                    LIMIT 10";
$stmt_sellers = $conn->prepare($sql_top_sellers);
$stmt_sellers->bind_param("ss", $start_date, $end_date);
$stmt_sellers->execute();
$top_sellers = $stmt_sellers->get_result();
$stmt_sellers->close();

include 'header.php';
?>

<h1>Satış Raporları</h1>
<p>Belirli bir tarih aralığındaki satış verilerini görüntüleyin.</p>

<div style="margin-bottom: 20px;">
    <form method="GET" action="reports.php" style="display: flex; gap: 10px; align-items: flex-end;">
        <div class="form-group" style="flex-basis: 40%;">
            <label for="start_date">Başlangıç Tarihi:</label>
            <input type="date" id="start_date" name="start_date" value="<?php echo htmlspecialchars($start_date); ?>">
        </div>
        <div class="form-group" style="flex-basis: 40%;">
            <label for="end_date">Bitiş Tarihi:</label>
            <input type="date" id="end_date" name="end_date" value="<?php echo htmlspecialchars($end_date); ?>">
        </div>
        <button type="submit" class="btn btn-primary" style="flex-basis: 20%;">Raporla</button>
    </form>
</div>

<hr>

<div style="display: flex; gap: 20px;">
    <div class="card" style="flex-basis: 48%; text-align: center;">
        <h2 style="color: var(--success-color);"><?php echo number_format($report_data['total_revenue'] ?? 0, 2) . " TL"; ?></h2>
        <p>Toplam Ciro</p>
    </div>
    <div class="card" style="flex-basis: 48%; text-align: center;">
        <h2 style="color: var(--primary-color);"><?php echo $report_data['total_quotes'] ?? 0; ?></h2>
        <p>Tamamlanan Teklif Sayısı</p>
    </div>
</div>

<h2 style="margin-top: 30px;">En Çok Satan Ürünler (İlk 10)</h2>
<?php if ($top_sellers->num_rows > 0): ?>
    <table>
        <thead>
            <tr>
                <th>Ürün Adı</th>
                <th>Toplam Satış Adedi</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $top_sellers->fetch_assoc()): ?>
            <tr>
                <td><?php echo htmlspecialchars($row['name']); ?></td>
                <td><?php echo htmlspecialchars($row['total_sold']); ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>Belirtilen tarih aralığında tamamlanmış teklif bulunmamaktadır.</p>
<?php endif; ?>

<?php
$conn->close();
include 'footer.php';
?>