<?php
session_start();
require 'db_connection.php';

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$agent_id = $_SESSION['agent_id'];

$sql_quotes = "SELECT q.id, q.quote_number, q.created_at, q.status, c.name AS customer_name 
               FROM quotes q 
               JOIN customers c ON q.customer_id = c.id 
               WHERE q.agent_id = ? 
               ORDER BY q.created_at DESC";
$stmt_quotes = $conn->prepare($sql_quotes);
$stmt_quotes->bind_param("i", $agent_id);
$stmt_quotes->execute();
$quotes = $stmt_quotes->get_result();

include 'header.php';
?>

<h1>Teklif Listesi</h1>
<?php if ($quotes->num_rows > 0): ?>
    <table>
        <thead>
            <tr>
                <th>Teklif No</th>
                <th>Müşteri Adı</th>
                <th>Durum</th>
                <th>Tarih</th>
                <th>İşlem</th>
                <th>Detay</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $quotes->fetch_assoc()): ?>
            <tr>
                <td><?php echo htmlspecialchars($row['quote_number']); ?></td>
                <td><?php echo htmlspecialchars($row['customer_name']); ?></td>
                <td>
                    <select class="status-selector" data-id="<?php echo $row['id']; ?>">
                        <option value="draft" <?php echo ($row['status'] == 'draft') ? 'selected' : ''; ?>>Taslak</option>
                        <option value="sent" <?php echo ($row['status'] == 'sent') ? 'selected' : ''; ?>>Gönderildi</option>
                        <option value="accepted" <?php echo ($row['status'] == 'accepted') ? 'selected' : ''; ?>>Kabul Edildi</option>
                        <option value="rejected" <?php echo ($row['status'] == 'rejected') ? 'selected' : ''; ?>>Reddedildi</option>
                    </select>
                </td>
                <td><?php echo htmlspecialchars($row['created_at']); ?></td>
                <td>
                    <button class="btn btn-primary update-status-btn" data-id="<?php echo $row['id']; ?>">Güncelle</button>
                </td>
                <td><a href="quote_details.php?id=<?php echo $row['id']; ?>">Gör</a></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>Henüz oluşturulmuş bir teklifiniz bulunmamaktadır.</p>
<?php endif; ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    $('.update-status-btn').click(function() {
        const quoteId = $(this).data('id');
        const newStatus = $(`select[data-id="${quoteId}"]`).val();

        $.ajax({
            url: 'update_quote_status.php',
            method: 'POST',
            data: { id: quoteId, status: newStatus },
            success: function(response) {
                alert(response.message);
                if (response.status === 'success') {
                    location.reload();
                }
            },
            error: function() {
                alert("Durum güncellenirken bir hata oluştu.");
            }
        });
    });
});
</script>

<?php
$stmt_quotes->close();
$conn->close();
include 'footer.php';
?>