<?php
require 'db_connection.php';
session_start();

$name = $_POST['name'] ?? null;
$email = $_POST['email'] ?? null;
$password = $_POST['password'] ?? null;

if (empty($name) || empty($email) || empty($password)) {
    die("Lütfen tüm alanları doldurun.");
}

// E-posta adresinin daha önce kullanılıp kullanılmadığını kontrol et
$sql_check_email = "SELECT email FROM customer_accounts WHERE email = ?";
$stmt_check = $conn->prepare($sql_check_email);
$stmt_check->bind_param("s", $email);
$stmt_check->execute();
$result_check = $stmt_check->get_result();

if ($result_check->num_rows > 0) {
    die("Bu e-posta adresi zaten kullanılıyor. Lütfen farklı bir e-posta deneyin.");
}
$stmt_check->close();

$hashed_password = password_hash($password, PASSWORD_DEFAULT);

$conn->begin_transaction();
try {
    // 1. customers tablosuna kaydet, otomatik olarak 1 numaralı temsilciye ata
    $default_agent_id = 1;
    $sql_customer = "INSERT INTO customers (agent_id, name, email) VALUES (?, ?, ?)";
    $stmt_customer = $conn->prepare($sql_customer);
    $stmt_customer->bind_param("iss", $default_agent_id, $name, $email);
    $stmt_customer->execute();
    $customer_id = $conn->insert_id;
    $stmt_customer->close();
    
    // 2. Ardından customer_accounts tablosuna hesap bilgilerini kaydet
    $sql_account = "INSERT INTO customer_accounts (customer_id, email, password) VALUES (?, ?, ?)";
    $stmt_account = $conn->prepare($sql_account);
    $stmt_account->bind_param("iss", $customer_id, $email, $hashed_password);
    $stmt_account->execute();
    $stmt_account->close();
    
    $conn->commit();
    
    $_SESSION['customer_id'] = $customer_id;
    $_SESSION['customer_logged_in'] = true;
    header("Location: customer_dashboard.php");
    exit();
    
} catch (mysqli_sql_exception $e) {
    $conn->rollback();
    echo "Hata: Kayıt işlemi başarısız. Lütfen tekrar deneyin. Detay: " . $e->getMessage();
}

$conn->close();
?>