<?php
session_start();
require 'db_connection.php';

if (isset($_SESSION['customer_logged_in']) && $_SESSION['customer_logged_in'] === true) {
    header("Location: customer_dashboard.php");
    exit;
}

include 'header_public.php';
?>

<div class="login-container">
    <div class="login-card">
        <h1>Müşteri Girişi</h1>
        <p>Hesabınızla giriş yaparak tekliflerinizi görüntüleyin.</p>
        <form action="customer_login_process.php" method="POST">
            <div class="form-group">
                <label for="email">E-posta</label>
                <input type="email" name="email" id="email" required>
            </div>
            <div class="form-group">
                <label for="password">Şifre</label>
                <input type="password" name="password" id="password" required>
            </div>
            <button type="submit" class="btn btn-primary" style="width: 100%;">Giriş Yap</button>
        </form>
        <hr style="margin-top: 20px; border-color: var(--border-color);">
        <p style="margin-top: 20px;">Hesabınız yok mu? <a href="customer_register.php" style="color: var(--primary-color); text-decoration: none;">Kayıt Olun</a></p>
    </div>
</div>

<?php
$conn->close();
include 'footer.php';
?>