<?php
session_start();
require 'db_connection.php';

header('Content-Type: application/json');

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    echo json_encode(['status' => 'error', 'message' => 'Lütfen giriş yapın.']);
    exit;
}

if (!isset($_POST['customerId']) || !isset($_POST['quoteItems'])) {
    echo json_encode(['status' => 'error', 'message' => 'Müşteri veya ürün bilgileri eksik.']);
    exit;
}

$customer_id = $_POST['customerId'];
$agent_id = $_SESSION['agent_id'];
$quote_items_json = $_POST['quoteItems'];

$quote_items = json_decode($quote_items_json, true);

if (json_last_error() !== JSON_ERROR_NONE || !is_array($quote_items) || empty($quote_items)) {
    echo json_encode(['status' => 'error', 'message' => 'Lütfen teklife ürün ekleyiniz.']);
    exit;
}

$conn->begin_transaction();

try {
    $quote_number = 'TOUZ-' . uniqid();
    $sql_quote = "INSERT INTO quotes (agent_id, customer_id, quote_number, status) VALUES (?, ?, ?, 'draft')";
    $stmt_quote = $conn->prepare($sql_quote);
    $stmt_quote->bind_param("iis", $agent_id, $customer_id, $quote_number);
    $stmt_quote->execute();

    $quote_id = $conn->insert_id;

    $sql_items = "INSERT INTO quote_items (quote_id, product_id, quantity, unit_price) VALUES (?, ?, ?, ?)";
    $stmt_items = $conn->prepare($sql_items);
    
    foreach ($quote_items as $item) {
        $stmt_items->bind_param("iidd", $quote_id, $item['productId'], $item['quantity'], $item['unitPrice']);
        $stmt_items->execute();
    }
    
    $conn->commit();
    echo json_encode(['status' => 'success', 'message' => 'Teklif başarıyla oluşturuldu! Teklif No: ' . $quote_number]);

} catch (mysqli_sql_exception $e) {
    $conn->rollback();
    echo json_encode(['status' => 'error', 'message' => 'Teklif kaydedilirken bir hata oluştu: ' . $e->getMessage()]);
} finally {
    if (isset($stmt_quote)) { $stmt_quote->close(); }
    if (isset($stmt_items)) { $stmt_items->close(); }
    $conn->close();
}
?>