<?php
session_start();
require 'db_connection.php';

header('Content-Type: application/json');

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    echo json_encode(['status' => 'error', 'message' => 'Lütfen giriş yapın.']);
    exit;
}

$quote_id = $_POST['id'] ?? null;
$new_status = $_POST['status'] ?? null;

if (empty($quote_id) || empty($new_status)) {
    echo json_encode(['status' => 'error', 'message' => 'Eksik bilgi gönderildi.']);
    exit;
}

$sql = "UPDATE quotes SET status = ? WHERE id = ? AND agent_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("sii", $new_status, $quote_id, $_SESSION['agent_id']);

if ($stmt->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Teklif durumu başarıyla güncellendi.']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Hata: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>