<?php
session_start();
require 'db_connection.php';

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Formdan gelen verileri al
$product_id = $_POST['product_id'] ?? null;
$category_id = $_POST['category_id'] ?? null;
$sku = $_POST['sku'] ?? null;
$name = $_POST['name'] ?? null;
$description = $_POST['description'] ?? null;
$price = $_POST['price'] ?? null;
$stock_quantity = $_POST['stock_quantity'] ?? null;
$image_url = $_POST['image_url'] ?? null;

// Gerekli verilerin kontrolü
if (empty($product_id) || empty($sku) || empty($name) || empty($price) || !isset($stock_quantity)) {
    $error_message = "Güncelleme için gerekli bilgiler eksik.";
    $success = false;
} else {
    // SQL sorgusunu hazırla (Güvenlik için parametreli sorgu)
    $sql = "UPDATE products SET category_id = ?, sku = ?, name = ?, description = ?, price = ?, stock_quantity = ?, image_url = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);

    // Kategori ID'si boşsa null olarak ayarla
    $category_id_param = empty($category_id) ? null : $category_id;

    if ($stmt) {
        $stmt->bind_param("isssdisi", $category_id_param, $sku, $name, $description, $price, $stock_quantity, $image_url, $product_id);

        if ($stmt->execute()) {
            $success = true;
        } else {
            $error_message = "Ürün güncellenirken bir hata oluştu: " . $stmt->error;
            $success = false;
        }
        $stmt->close();
    } else {
        $error_message = "Sorgu hazırlanamadı: " . $conn->error;
        $success = false;
    }
}

$conn->close();

include 'header.php';

if ($success) {
    echo '<div class="message-box">';
    echo '<h1>Başarılı</h1>';
    echo '<p>Ürün başarıyla güncellendi.</p>';
    echo '<a href="list_products.php" class="btn btn-primary">Ürün Listesine Dön</a>';
    echo '</div>';
} else {
    echo '<div class="message-box error">';
    echo '<h1>Hata</h1>';
    echo '<p>' . $error_message . '</p>';
    echo '<a href="list_products.php" class="btn btn-secondary">Geri Dön</a>';
    echo '</div>';
}

include 'footer.php';