<?php
include 'header_public.php';
?>

<h1>Sipariş Formu</h1>
<p style="text-align: center;">Lütfen bilgilerinizi girerek sepetinizdeki ürünler için teklif isteyin.</p>

<form id="quote-request-form">
    <div class="form-group">
        <label for="name">Adınız Soyadınız:</label>
        <input type="text" id="name" name="name" required>
    </div>
    <div class="form-group">
        <label for="email">E-posta Adresiniz:</label>
        <input type="email" id="email" name="email" required>
    </div>
    <div class="form-group">
        <label for="phone">Telefon Numaranız:</label>
        <input type="text" id="phone" name="phone">
    </div>
    <div class="form-group">
        <label for="message">Eklemek İstediğiniz Notlar:</label>
        <textarea id="message" name="message" rows="4"></textarea>
    </div>
    
    <hr>
    <h2>Sepetinizdeki Ürünler</h2>
    <p id="cart-empty-message" style="text-align: center; font-style: italic;"></p>
    <table id="cart-summary-table">
        <thead>
            <tr>
                <th>Ürün Adı</th>
                <th>Adet</th>
                <th>Birim Fiyat</th>
                <th>Toplam</th>
            </tr>
        </thead>
        <tbody id="cart-items-body">
        </tbody>
    </table>
    
    <button type="submit" id="submit-request-btn" class="btn btn-primary">Teklif İsteğini Gönder</button>
</form>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    const cart = JSON.parse(localStorage.getItem('touzmoda_cart')) || {};

    function renderCartSummary() {
        const cartItemsBody = $('#cart-items-body');
        cartItemsBody.empty();
        let hasItems = false;
        let grandTotal = 0;

        for (const productId in cart) {
            if (cart.hasOwnProperty(productId)) {
                hasItems = true;
                const item = cart[productId];
                const total = item.quantity * item.price;
                grandTotal += total;
                const row = `
                    <tr>
                        <td>${item.name}</td>
                        <td>${item.quantity}</td>
                        <td>${item.price.toFixed(2)} TL</td>
                        <td>${total.toFixed(2)} TL</td>
                    </tr>
                `;
                cartItemsBody.append(row);
            }
        }

        if (!hasItems) {
            $('#cart-empty-message').text('Sepetinizde ürün bulunmamaktadır.');
            $('#cart-summary-table').hide();
            $('#submit-request-btn').hide();
        } else {
            $('#cart-empty-message').hide();
            $('#cart-summary-table').show();
            $('#submit-request-btn').show();
        }
    }

    renderCartSummary();

    $('#quote-request-form').on('submit', function(e) {
        e.preventDefault();

        const name = $('#name').val();
        const email = $('#email').val();
        const phone = $('#phone').val();
        const message = $('#message').val();

        if (Object.keys(cart).length === 0) {
            alert("Sepetinizde ürün olmadığı için teklif talebi gönderemezsiniz.");
            return;
        }

        const requestData = {
            name: name,
            email: email,
            phone: phone,
            message: message,
            items: cart
        };

        $.ajax({
            url: 'process_request.php',
            method: 'POST',
            data: requestData,
            success: function(response) {
                alert(response.message);
                if (response.status === 'success') {
                    localStorage.removeItem('touzmoda_cart');
                    window.location.href = 'customer_home.php';
                }
            },
            error: function() {
                alert("Teklif talebi gönderilirken bir hata oluştu.");
            }
        });
    });
});
</script>

<?php
$conn->close();
include 'footer.php';
?>