<?php
require 'db_connection.php';

header('Content-Type: application/json');

$name = $_POST['name'] ?? '';
$email = $_POST['email'] ?? '';
$phone = $_POST['phone'] ?? '';
$message = $_POST['message'] ?? '';
$items = $_POST['items'] ?? [];

if (empty($name) || empty($email) || empty($items)) {
    echo json_encode(['status' => 'error', 'message' => 'Lütfen adınızı, e-posta adresinizi ve ürün bilgilerinizi eksiksiz doldurun.']);
    exit;
}

$conn->begin_transaction();

try {
    $sql_request = "INSERT INTO quote_requests (name, email, phone, message) VALUES (?, ?, ?, ?)";
    $stmt_request = $conn->prepare($sql_request);
    $stmt_request->bind_param("ssss", $name, $email, $phone, $message);
    $stmt_request->execute();

    $request_id = $conn->insert_id;

    $sql_items = "INSERT INTO quote_request_items (request_id, product_id, quantity, unit_price) VALUES (?, ?, ?, ?)";
    $stmt_items = $conn->prepare($sql_items);
    
    foreach ($items as $item) {
        $stmt_items->bind_param("iidd", $request_id, $item['id'], $item['quantity'], $item['price']);
        $stmt_items->execute();
    }
    
    $conn->commit();
    echo json_encode(['status' => 'success', 'message' => 'Teklif talebiniz başarıyla gönderildi! Touzmoda ekibi en kısa sürede size geri dönüş yapacaktır.']);

} catch (mysqli_sql_exception $e) {
    $conn->rollback();
    echo json_encode(['status' => 'error', 'message' => 'Teklif talebi gönderilirken bir hata oluştu: ' . $e->getMessage()]);
} finally {
    if (isset($stmt_request)) { $stmt_request->close(); }
    if (isset($stmt_items)) { $stmt_items->close(); }
    $conn->close();
}
?>