<?php
session_start();
require 'db_connection.php';

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$sql = "SELECT p.*, c.name AS category_name FROM products p LEFT JOIN categories c ON p.category_id = c.id ORDER BY p.id DESC";
$result = $conn->query($sql);

include 'header.php';
?>

<h1>Ürün Listesi</h1>
<?php if ($result->num_rows > 0): ?>
    <table>
        <thead>
            <tr>
                <th>Görsel</th>
                <th>SKU</th>
                <th>Ürün Adı</th>
                <th>Kategori</th>
                <th>Fiyat</th>
                <th>Stok</th>
                <th>Açıklama</th>
                <th>İşlem</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $result->fetch_assoc()): ?>
            <tr>
                <td>
                    <?php if (!empty($row['image_url'])): ?>
                        <img src="<?php echo htmlspecialchars($row['image_url']); ?>" alt="<?php echo htmlspecialchars($row['name']); ?>" class="product-image-thumbnail">
                    <?php endif; ?>
                </td>
                <td><?php echo htmlspecialchars($row['sku']); ?></td>
                <td><?php echo htmlspecialchars($row['name']); ?></td>
                <td><?php echo htmlspecialchars($row['category_name'] ?? 'Yok'); ?></td>
                <td><?php echo number_format($row['price'], 2) . " TL"; ?></td>
                <td><?php echo htmlspecialchars($row['stock_quantity']); ?></td>
                <td><?php echo htmlspecialchars($row['description']); ?></td>
                <td>
                    <a href="edit_product.php?id=<?php echo $row['id']; ?>" class="btn btn-secondary" style="padding: 5px 10px;">Düzenle</a>
                    <button class="btn btn-danger delete-product-btn" data-id="<?php echo $row['id']; ?>" style="padding: 5px 10px;">X</button>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>Henüz eklenmiş ürün bulunmamaktadır.</p>
<?php endif; ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    $('.delete-product-btn').click(function() {
        const productId = $(this).data('id');
        const confirmation = confirm("Bu ürünü kalıcı olarak silmek istediğinizden emin misiniz?");
        
        if (confirmation) {
            $.ajax({
                url: 'delete_product.php',
                method: 'POST',
                data: { product_id: productId },
                success: function(response) {
                    alert(response.message);
                    if (response.status === 'success') {
                        location.reload();
                    }
                },
                error: function() {
                    alert("Silme işlemi sırasında bir hata oluştu.");
                }
            });
        }
    });
});
</script>

<?php
$conn->close();
include 'footer.php';
?>