<?php
session_start();
require 'db_connection.php';

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$agent_id = $_SESSION['agent_id'];

$sql_customers = "SELECT id, name FROM customers WHERE agent_id = ? ORDER BY name ASC";
$stmt_customers = $conn->prepare($sql_customers);
$stmt_customers->bind_param("i", $agent_id);
$stmt_customers->execute();
$customers = $stmt_customers->get_result();

$sql_products = "SELECT id, sku, name, price FROM products ORDER BY name ASC";
$products = $conn->query($sql_products);

include 'header.php';
?>

<h1>Yeni Fiyat Teklifi Oluştur</h1>
<form id="quote-form">
    <div class="form-group">
        <label for="customer_id">Müşteri Seçin:</label>
        <select id="customer_id" name="customer_id" required>
            <option value="">-- Müşteri Seçiniz --</option>
            <?php while($row = $customers->fetch_assoc()): ?>
                <option value="<?php echo $row['id']; ?>"><?php echo htmlspecialchars($row['name']); ?></option>
            <?php endwhile; ?>
        </select>
    </div>
    <hr>
    <h2>Ürün Ekle</h2>
    <div class="form-group">
        <label for="product_id">Ürün Seçin:</label>
        <select id="product_id" name="product_id">
            <option value="">-- Ürün Seçiniz --</option>
            <?php while($row = $products->fetch_assoc()): ?>
                <option value="<?php echo $row['id']; ?>" data-price="<?php echo $row['price']; ?>"><?php echo htmlspecialchars($row['name'] . ' (' . $row['sku'] . ')'); ?></option>
            <?php endwhile; ?>
        </select>
    </div>
    <div class="form-group">
        <label for="quantity">Adet:</label>
        <input type="number" id="quantity" name="quantity" value="1" min="1" required>
    </div>
    <div class="form-group">
        <label for="unit_price">Birim Fiyat:</label>
        <input type="number" id="unit_price" name="unit_price" step="0.01" required>
    </div>
    <button type="button" id="add-product-btn" class="btn btn-success">Ürünü Sepete Ekle</button>
</form>

<hr>
<h2>Teklif Sepeti</h2>
<table id="quote-table">
    <thead>
        <tr>
            <th>Ürün Adı</th>
            <th>Adet</th>
            <th>Birim Fiyat</th>
            <th>Toplam</th>
            <th>İşlem</th>
        </tr>
    </thead>
    <tbody id="quote-items-body">
    </tbody>
    <tfoot>
        <tr>
            <td colspan="3"><strong>Genel Toplam:</strong></td>
            <td id="grand-total">0.00 TL</td>
            <td></td>
        </tr>
    </tfoot>
</table>

<button id="submit-quote-btn" class="btn btn-primary">Teklifi Oluştur ve Kaydet</button>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    let quoteItems = [];
    
    $('#product_id').change(function() {
        const selectedOption = $(this).find('option:selected');
        const price = selectedOption.data('price');
        $('#unit_price').val(price);
    });

    $('#add-product-btn').click(function() {
        const productId = $('#product_id').val();
        const quantity = $('#quantity').val();
        const unitPrice = $('#unit_price').val();
        const productName = $('#product_id option:selected').text();
        
        if (productId && quantity > 0 && unitPrice > 0) {
            const newItem = {
                productId: productId,
                productName: productName,
                quantity: quantity,
                unitPrice: unitPrice
            };
            quoteItems.push(newItem);
            renderQuoteItems();
        } else {
            alert("Lütfen ürün, adet ve fiyat bilgilerini eksiksiz giriniz.");
        }
    });

    $(document).on('click', '.remove-item-btn', function() {
        const index = $(this).data('index');
        quoteItems.splice(index, 1);
        renderQuoteItems();
    });

    function renderQuoteItems() {
        const tbody = $('#quote-items-body');
        tbody.empty();
        let grandTotal = 0;
        
        quoteItems.forEach((item, index) => {
            const total = item.quantity * item.unitPrice;
            grandTotal += total;
            const row = `
                <tr>
                    <td>${item.productName}</td>
                    <td>${item.quantity}</td>
                    <td>${item.unitPrice} TL</td>
                    <td>${total.toFixed(2)} TL</td>
                    <td><span class="remove-item-btn" data-index="${index}">X</span></td>
                </tr>
            `;
            tbody.append(row);
        });
        $('#grand-total').text(grandTotal.toFixed(2) + ' TL');
    }

    $('#submit-quote-btn').click(function() {
        const customerId = $('#customer_id').val();
        if (!customerId) {
            alert("Lütfen bir müşteri seçiniz.");
            return;
        }
        if (quoteItems.length === 0) {
            alert("Lütfen teklife ürün ekleyiniz.");
            return;
        }
        
        const postData = {
            customerId: customerId,
            quoteItems: JSON.stringify(quoteItems)
        };
        
        $.ajax({
            url: 'add_quote_process.php',
            method: 'POST',
            data: postData,
            success: function(response) {
                alert(response.message);
                if (response.status === 'success') {
                    window.location.href = 'dashboard.php';
                }
            },
            error: function(xhr, status, error) {
                alert("Teklif oluşturulurken bir hata oluştu. Detay: " + xhr.responseText);
            }
        });
    });
});
</script>

<?php
$conn->close();
include 'footer.php';
?>