<?php
session_start();
require 'db_connection.php';
header('Content-Type: application/json');

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    echo json_encode(['status' => 'error', 'message' => 'Lütfen giriş yapın.']);
    exit;
}

$name = $_POST['name'] ?? '';
$image_url = $_POST['image_url'] ?? '';

if (empty($name)) {
    echo json_encode(['status' => 'error', 'message' => 'Kategori adı boş olamaz.']);
    exit;
}

$sql = "INSERT INTO categories (name, image_url) VALUES (?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $name, $image_url);

if ($stmt->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Kategori başarıyla eklendi!']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Hata: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>